/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.dispatch.configurationProcessors;

import com.aptana.configurations.processor.ConfigurationStatus;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IOUtil;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.dispatch.configurationProcessors.InstallerConfigurationProcessor;
import com.aptana.portal.ui.dispatch.configurationProcessors.Messages;
import com.aptana.portal.ui.dispatch.configurationProcessors.installer.JavaScriptImporterOptionsDialog;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class JavaScriptLibraryInstallProcessor
extends InstallerConfigurationProcessor {
    private static final String JS_LIBRARY = "JS Library";
    private static boolean installationInProgress;
    private String libraryName;
    private IProject targetProject;

    protected String getApplicationName() {
        return this.libraryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationStatus configure(IProgressMonitor progressMonitor, Object attributes) {
        block28: {
            block27: {
                Class<?> clazz;
                ConfigurationStatus configurationStatus;
                Class<?> clazz2 = ((Object)((Object)this)).getClass();
                synchronized (clazz2) {
                    if (installationInProgress) {
                        return this.configurationStatus;
                    }
                    installationInProgress = true;
                }
                try {
                    this.configurationStatus.removeAttribute("configurations");
                    this.clearErrorAttributes();
                    IStatus loadingStatus = this.loadAttributes(attributes);
                    if (loadingStatus.isOK()) break block27;
                    String message = loadingStatus.getMessage();
                    this.applyErrorAttributes(message);
                    IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(message));
                    configurationStatus = this.configurationStatus;
                    clazz = ((Object)((Object)this)).getClass();
                }
                catch (Throwable throwable) {
                    Class<?> clazz3 = ((Object)((Object)this)).getClass();
                    synchronized (clazz3) {
                        installationInProgress = false;
                    }
                    throw throwable;
                }
                synchronized (clazz) {
                    installationInProgress = false;
                }
                return configurationStatus;
            }
            if (this.urls.length != 0) break block28;
            String err = NLS.bind((String)Messages.InstallProcessor_wrongNumberOfInstallLinks, (Object[])new Object[]{JS_LIBRARY, 1, this.urls.length});
            this.applyErrorAttributes(err);
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(err));
            ConfigurationStatus configurationStatus = this.configurationStatus;
            Class<?> clazz = ((Object)((Object)this)).getClass();
            synchronized (clazz) {
                installationInProgress = false;
            }
            return configurationStatus;
        }
        this.libraryName = (String)this.attributesMap.get("name");
        if (this.libraryName == null) {
            this.libraryName = JS_LIBRARY;
            IdeLog.logWarning((Plugin)PortalUIPlugin.getDefault(), (String)"Expected a name attribute for the JS library, but got null.");
        }
        this.configurationStatus.setStatus("processing");
        IStatus status = this.download(this.urls, progressMonitor);
        if (status.isOK()) {
            status = this.install(progressMonitor);
        }
        switch (status.getSeverity()) {
            case 0: 
            case 1: 
            case 2: {
                this.displayMessageInUIThread(2, NLS.bind((String)Messages.InstallProcessor_installerTitle, (Object)this.libraryName), NLS.bind((String)Messages.InstallProcessor_installationSuccessful, (Object)this.libraryName));
                this.configurationStatus.setStatus("ok");
                break;
            }
            case 4: {
                this.configurationStatus.setStatus("error");
                break;
            }
            case 8: {
                this.configurationStatus.setStatus("incomplete");
                break;
            }
            default: {
                this.configurationStatus.setStatus("unknown");
            }
        }
        ConfigurationStatus configurationStatus = this.configurationStatus;
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            installationInProgress = false;
        }
        return configurationStatus;
    }

    protected IStatus install(IProgressMonitor progressMonitor) {
        UIJob job = new UIJob(Messages.JSLibraryInstallProcessor_directorySelection){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                JavaScriptImporterOptionsDialog dialog = new JavaScriptImporterOptionsDialog(Display.getDefault().getActiveShell(), JavaScriptLibraryInstallProcessor.this.libraryName);
                if (dialog.open() == 0) {
                    String selectedLocation = dialog.getSelectedLocation();
                    IPath path = Path.fromOSString((String)selectedLocation);
                    JavaScriptLibraryInstallProcessor.this.targetProject = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                    if (JavaScriptLibraryInstallProcessor.this.targetProject != null) {
                        String fullPath = JavaScriptLibraryInstallProcessor.this.targetProject.getLocation().append(path.removeFirstSegments(1)).toOSString();
                        File targetFolder = new File(fullPath);
                        if (!targetFolder.exists() && !targetFolder.mkdirs()) {
                            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)"Failed to create directories when importing JS slibrary!", (Throwable)new Exception("Failed to create '" + fullPath + '\''));
                            return new Status(4, "com.aptana.portal.ui", Messages.JSLibraryInstallProcessor_directoriesCreationFailed);
                        }
                        ArrayList<Status> errors = new ArrayList<Status>();
                        for (IPath f : JavaScriptLibraryInstallProcessor.this.downloadedPaths) {
                            try {
                                File sourceLocation = f.toFile();
                                File targetLocation = new File(targetFolder, sourceLocation.getName());
                                if (targetLocation.exists() && !MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.JSLibraryInstallProcessor_fileConflictTitle, (String)(String.valueOf(Messages.JSLibraryInstallProcessor_fileConflictMessage) + sourceLocation.getName() + Messages.JSLibraryInstallProcessor_overwriteQuestion))) continue;
                                IOUtil.copyFile((File)sourceLocation, (File)targetLocation);
                            }
                            catch (IOException e) {
                                errors.add(new Status(4, "com.aptana.portal.ui", e.getMessage(), (Throwable)e));
                            }
                        }
                        if (!errors.isEmpty()) {
                            return new MultiStatus("com.aptana.portal.ui", 0, errors.toArray(new IStatus[errors.size()]), Messages.JSLibraryInstallProcessor_multipleErrorsWhileImportingJS, null);
                        }
                    } else {
                        IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)"Unexpected null project when importing a JS library!", (Throwable)new Exception());
                        return new Status(4, "com.aptana.portal.ui", Messages.JSLibraryInstallProcessor_unexpectedNull);
                    }
                    JavaScriptLibraryInstallProcessor.this.finalizeInstallation(null);
                    try {
                        JavaScriptLibraryInstallProcessor.this.targetProject.refreshLocal(2, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
                    }
                    catch (CoreException e) {
                        IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (String)"Error while refreshing the project.", (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)e);
        }
        return job.getResult();
    }
}

